<?php
declare(strict_types=1);
require_once __DIR__ . '/paths.php';
require_once __DIR__ . '/conexao_db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/funcoes.php';
require_login();

$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare('SELECT * FROM ficha_anamnese_tirzepatida WHERE id=:id');
$st->execute([':id' => $id]);
$r = $st->fetch();
if(!$r){ http_response_code(404); exit('Registro não encontrado'); }
$csrf = csrf_token();
function s($v){return htmlspecialchars((string)$v);} $checked = fn($v)=> ((int)$v===1?'checked':'');
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Editar ficha #<?= (int)$r['id'] ?></title>
<link rel="stylesheet" href="<?= public_url('assets/style.css') ?>">
</head>
<body><main class="container"><h1>Editar – #<?= (int)$r['id'] ?> <?= s($r['nome_completo']) ?></h1>
<form action="<?= src_url('atualizar.php') ?>" method="post">
  <input type="hidden" name="csrf" value="<?= s($csrf) ?>">
  <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
  <section><h2>Dados Pessoais</h2>
    <div class="grid g3">
      <label>Nome completo*<input name="nome_completo" required maxlength="150" value="<?= s($r['nome_completo']) ?>"></label>
      <label>Data de nascimento*<input type="date" name="data_nascimento" required value="<?= s($r['data_nascimento']) ?>"></label>
      <label>Sexo*<select name="sexo" required>
        <option value="M" <?= $r['sexo']==='M'?'selected':''; ?>>M</option>
        <option value="F" <?= $r['sexo']==='F'?'selected':''; ?>>F</option>
      </select></label>
    </div>
    <div class="grid g3">
      <label>Telefone<input name="telefone" value="<?= s($r['telefone']) ?>"></label>
      <label>E-mail<input type="email" name="email" value="<?= s($r['email']) ?>"></label>
      <label>Profissão<input name="profissao" value="<?= s($r['profissao']) ?>"></label>
    </div>
  </section>
  <section><h2>Histórico Médico</h2>
    <?php $hx=['diabetes_tipo2','diabetes_tipo1','hipertensao','problemas_renais','doencas_hepaticas','pancreatite_dor_abdominal','doencas_gastrointestinais','cancer_tireoide','neoplasia_endocrina_multipla','alergias_medicamentosas']; foreach($hx as $k): ?>
      <label class="ck"><input type="checkbox" name="<?= $k ?>" value="1" <?= $checked($r[$k]) ?>> <?= $k ?></label>
    <?php endforeach; ?>
    <label>Quais alergias? <input name="quais_alergias" value="<?= s($r['quais_alergias']) ?>"></label>
  </section>
  <section><h2>Uso de Medicamentos</h2>
    <label>Uso contínuo<textarea name="medicamentos_uso_continuo" rows="2"><?= s($r['medicamentos_uso_continuo']) ?></textarea></label>
    <label>Suplementos<textarea name="suplementos_vitaminas" rows="2"><?= s($r['suplementos_vitaminas']) ?></textarea></label>
  </section>
  <section><h2>Objetivos</h2>
    <?php $obj=['objetivo_emagrecimento','objetivo_controle_glicemico','objetivo_reducao_compulsao','objetivo_melhoria_metabolismo']; foreach($obj as $k): ?>
      <label class="ck"><input type="checkbox" name="<?= $k ?>" value="1" <?= $checked($r[$k]) ?>> <?= $k ?></label>
    <?php endforeach; ?>
    <label>Outros <input name="objetivo_outros" value="<?= s($r['objetivo_outros']) ?>"></label>
  </section>
  <section><h2>Avaliação Corporal</h2>
    <div class="grid g3">
      <label>Peso (kg)<input type="number" step="0.01" name="peso" value="<?= s($r['peso']) ?>"></label>
      <label>Altura (m)<input type="number" step="0.01" name="altura" value="<?= s($r['altura']) ?>"></label>
      <label>IMC<input type="number" step="0.01" name="imc" value="<?= s($r['imc']) ?>"></label>
    </div>
    <div class="grid g4">
      <label>Cintura<input type="number" step="0.1" name="cintura" value="<?= s($r['cintura']) ?>"></label>
      <label>Abdômen<input type="number" step="0.1" name="abdomen" value="<?= s($r['abdomen']) ?>"></label>
      <label>Quadril<input type="number" step="0.1" name="quadril" value="<?= s($r['quadril']) ?>"></label>
      <label>Coxa<input type="number" step="0.1" name="coxa" value="<?= s($r['coxa']) ?>"></label>
    </div>
  </section>
  <section><h2>Hábitos de Vida</h2>
    <?php $hb=['alimentacao_equilibrada','atividade_fisica','ingestao_agua_adequada','alcool','tabagismo','sono_reparador']; foreach($hb as $k): ?>
      <label class="ck"><input type="checkbox" name="<?= $k ?>" value="1" <?= $checked($r[$k]) ?>> <?= $k ?></label>
    <?php endforeach; ?>
    <label>Tipo atividade <input name="tipo_atividade" value="<?= s($r['tipo_atividade']) ?>"></label>
    <label>Frequência <input name="frequencia_atividade" value="<?= s($r['frequencia_atividade']) ?>"></label>
    <label>Média água (ml/dia) <input type="number" name="media_agua_ml" value="<?= s($r['media_agua_ml']) ?>"></label>
    <label>Frequência álcool <input name="frequencia_alcool" value="<?= s($r['frequencia_alcool']) ?>"></label>
    <label>Quantidade tabaco <input name="quantidade_tabaco" value="<?= s($r['quantidade_tabaco']) ?>"></label>
    <label>Horas de sono <input type="number" name="horas_sono" value="<?= s($r['horas_sono']) ?>"></label>
  </section>
  <section><h2>Tirzepatida</h2>
    <div class="grid g3">
      <label>Já utilizou?
        <select name="utilizou_tirzepatida">
          <option value="0" <?= ((int)$r['utilizou_tirzepatida']===0?'selected':'') ?>>Não</option>
          <option value="1" <?= ((int)$r['utilizou_tirzepatida']===1?'selected':'') ?>>Sim</option>
        </select>
      </label>
      <label>Data de início<input type="date" name="data_inicio" value="<?= s($r['data_inicio']) ?>"></label>
      <label>Dosagem<input name="dosagem" value="<?= s($r['dosagem']) ?>"></label>
    </div>
    <div class="grid g3">
      <label>Forma de aquisição
        <select name="forma_aquisicao">
          <option value="">Selecione</option>
          <option value="Prescrito" <?= $r['forma_aquisicao']==='Prescrito'?'selected':''; ?>>Prescrito</option>
          <option value="Outro" <?= $r['forma_aquisicao']==='Outro'?'selected':''; ?>>Outro</option>
        </select>
      </label>
      <label>Outro (aquisição)<input name="outro_aquisicao" value="<?= s($r['outro_aquisicao']) ?>"></label>
      <label>Ciente efeitos
        <select name="ciente_efeitos_colaterais">
          <option value="0" <?= ((int)$r['ciente_efeitos_colaterais']===0?'selected':'') ?>>Não</option>
          <option value="1" <?= ((int)$r['ciente_efeitos_colaterais']===1?'selected':'') ?>>Sim</option>
        </select>
      </label>
    </div>
    <label>Recebeu orientações
      <select name="recebeu_orientacoes">
        <option value="0" <?= ((int)$r['recebeu_orientacoes']===0?'selected':'') ?>>Não</option>
        <option value="1" <?= ((int)$r['recebeu_orientacoes']===1?'selected':'') ?>>Sim</option>
      </select>
    </label>
  </section>

  <button type="submit">Salvar alterações</button>
</form>
</main></body></html>
