<?php
declare(strict_types=1);

require_once __DIR__ . '/paths.php';
require_once __DIR__ . '/conexao_db.php';
require_once __DIR__ . '/auth.php';

$login = trim((string)($_POST['login'] ?? ''));
$senha = (string)($_POST['senha'] ?? '');

$st = $pdo->prepare('SELECT * FROM anamnese_usuarios WHERE login=:l AND ativo=1');
$st->execute([':l' => $login]);
$u = $st->fetch(PDO::FETCH_ASSOC);

if (!$u || !password_verify($senha, $u['senha_hash'])) {
  header('Location: ' . public_url('login.php?err=Credenciais inválidas'));
  exit;
}

auth_login($u);
header('Location: ' . public_url('menu.php'));
exit;
