<?php
declare(strict_types=1);
require_once __DIR__ . '/paths.php';
require_once __DIR__ . '/conexao_db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/funcoes.php';
require_login();
if (!csrf_ok((string)($_POST['csrf'] ?? ''))) { http_response_code(400); exit('CSRF inválido'); }

$id = (int)($_POST['id'] ?? 0); if ($id <= 0) { http_response_code(400); exit('ID inválido'); }
$cb = fn(string $k): int => isset($_POST[$k]) && (string)$_POST[$k] === '1' ? 1 : (int)($_POST[$k] ?? 0);
$get = fn(string $k): ?string => (($v = limpar((string)($_POST[$k] ?? ''))) !== '') ? $v : null;

$nome=$get('nome_completo'); $nasc=$get('data_nascimento'); $sexo=$get('sexo'); $tel=$get('telefone'); $email=$get('email'); $prof=$get('profissao');
$idade = $nasc ? (new DateTime($nasc))->diff(new DateTime('today'))->y : null;
$peso = isset($_POST['peso'])&&$_POST['peso']!==''?(float)$_POST['peso']:null;
$altura= isset($_POST['altura'])&&$_POST['altura']!==''?(float)$_POST['altura']:null;
$imc  = isset($_POST['imc'])&&$_POST['imc']!==''?(float)$_POST['imc']:(($peso && $altura)?round($peso/($altura*$altura),2):null);

$sql='UPDATE ficha_anamnese_tirzepatida SET
  nome_completo=:nome, data_nascimento=:nasc, idade=:idade, sexo=:sexo, telefone=:tel, email=:email, profissao=:prof,
  diabetes_tipo2=:d2, diabetes_tipo1=:d1, hipertensao=:hip, problemas_renais=:pr, doencas_hepaticas=:dh, pancreatite_dor_abdominal=:pan,
  doencas_gastrointestinais=:gi, cancer_tireoide=:ct, neoplasia_endocrina_multipla=:nem, alergias_medicamentosas=:alerg, quais_alergias=:qalg,
  medicamentos_uso_continuo=:mud, suplementos_vitaminas=:sup,
  objetivo_emagrecimento=:o1, objetivo_controle_glicemico=:o2, objetivo_reducao_compulsao=:o3, objetivo_melhoria_metabolismo=:o4, objetivo_outros=:o5,
  peso=:peso, altura=:altura, imc=:imc, cintura=:cint, abdomen=:abd, quadril=:qua, coxa=:coxa,
  alimentacao_equilibrada=:ae, atividade_fisica=:af, tipo_atividade=:ta, frequencia_atividade=:fa, ingestao_agua_adequada=:iaa, media_agua_ml=:agua,
  alcool=:alc, frequencia_alcool=:fal, tabagismo=:tab, quantidade_tabaco=:qtab, sono_reparador=:sono, horas_sono=:hsono,
  utilizou_tirzepatida=:uti, data_inicio=:dt, dosagem=:dos, forma_aquisicao=:form, outro_aquisicao=:outro, ciente_efeitos_colaterais=:cec, recebeu_orientacoes=:ro
  WHERE id=:id';

$st=$pdo->prepare($sql);
$st->execute([
  ':id'=>$id, ':nome'=>$nome, ':nasc'=>$nasc, ':idade'=>$idade, ':sexo'=>$sexo, ':tel'=>$tel, ':email'=>$email, ':prof'=>$prof,
  ':d2'=>$cb('diabetes_tipo2'), ':d1'=>$cb('diabetes_tipo1'), ':hip'=>$cb('hipertensao'), ':pr'=>$cb('problemas_renais'), ':dh'=>$cb('doencas_hepaticas'), ':pan'=>$cb('pancreatite_dor_abdominal'),
  ':gi'=>$cb('doencas_gastrointestinais'), ':ct'=>$cb('cancer_tireoide'), ':nem'=>$cb('neoplasia_endocrina_multipla'), ':alerg'=>$cb('alergias_medicamentosas'), ':qalg'=>$get('quais_alergias'),
  ':mud'=>$get('medicamentos_uso_continuo'), ':sup'=>$get('suplementos_vitaminas'),
  ':o1'=>$cb('objetivo_emagrecimento'), ':o2'=>$cb('objetivo_controle_glicemico'), ':o3'=>$cb('objetivo_reducao_compulsao'), ':o4'=>$cb('objetivo_melhoria_metabolismo'), ':o5'=>$get('objetivo_outros'),
  ':peso'=>$peso, ':altura'=>$altura, ':imc'=>$imc, ':cint'=>isset($_POST['cintura'])&&$_POST['cintura']!==''?(float)$_POST['cintura']:null,
  ':abd'=>isset($_POST['abdomen'])&&$_POST['abdomen']!==''?(float)$_POST['abdomen']:null,
  ':qua'=>isset($_POST['quadril'])&&$_POST['quadril']!==''?(float)$_POST['quadril']:null,
  ':coxa'=>isset($_POST['coxa'])&&$_POST['coxa']!==''?(float)$_POST['coxa']:null,
  ':ae'=>$cb('alimentacao_equilibrada'), ':af'=>$cb('atividade_fisica'), ':ta'=>$get('tipo_atividade'), ':fa'=>$get('frequencia_atividade'),
  ':iaa'=>$cb('ingestao_agua_adequada'), ':agua'=>isset($_POST['media_agua_ml'])&&$_POST['media_agua_ml']!==''?(int)$_POST['media_agua_ml']:null,
  ':alc'=>$cb('alcool'), ':fal'=>$get('frequencia_alcool'), ':tab'=>$cb('tabagismo'), ':qtab'=>$get('quantidade_tabaco'), ':sono'=>$cb('sono_reparador'),
  ':hsono'=>isset($_POST['horas_sono'])&&$_POST['horas_sono']!==''?(int)$_POST['horas_sono']:null,
  ':uti'=>$cb('utilizou_tirzepatida'), ':dt'=>$get('data_inicio'), ':dos'=>$get('dosagem'), ':form'=>$get('forma_aquisicao'), ':outro'=>$get('outro_aquisicao'),
  ':cec'=>isset($_POST['ciente_efeitos_colaterais'])?(int)$_POST['ciente_efeitos_colaterais']:0, ':ro'=>isset($_POST['recebeu_orientacoes'])?(int)$_POST['recebeu_orientacoes']:0,
]);
header('Location: ' . src_url('ver.php?id='.$id));
