<?php
declare(strict_types=1);

require_once __DIR__ . '/paths.php';
require_once __DIR__ . '/conexao_db.php';
require_once __DIR__ . '/auth.php';

require_login();

$page = max(1, (int)($_GET['page'] ?? 1));
$limit = 20;
$offset = ($page - 1) * $limit;
$q = trim((string)($_GET['q'] ?? ''));

$where = '';
$args = [];
if ($q !== '') {
  $where = 'WHERE nome_completo LIKE :q OR email LIKE :q OR telefone LIKE :q';
  $args[':q'] = "%$q%";
}

$stC = $pdo->prepare("SELECT COUNT(*) FROM ficha_anamnese_tirzepatida $where");
$stC->execute($args);
$total = (int)$stC->fetchColumn();

$sql = "SELECT id, nome_completo, email, telefone, sexo, idade, criado_em
        FROM ficha_anamnese_tirzepatida $where
        ORDER BY criado_em DESC LIMIT :limit OFFSET :offset";

$st = $pdo->prepare($sql);
foreach ($args as $k => $v) {
  $st->bindValue($k, $v);
}
$st->bindValue(':limit', $limit, PDO::PARAM_INT);
$st->bindValue(':offset', $offset, PDO::PARAM_INT);
$st->execute();
$rows = $st->fetchAll();

$pages = max(1, (int)ceil($total / $limit));
$csrf = csrf_token();
?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Lista – Anamnese</title>
<style>
body{font-family:system-ui,Segoe UI,Roboto,sans-serif;padding:24px;color:#0b1220}
.table{width:100%;border-collapse:collapse}
th,td{border:1px solid #d7dbe3;padding:8px} th{background:#eef2f8;text-align:left}
.bar{display:flex;gap:12px;align-items:center;margin-bottom:10px}
.actions a, .actions form{display:inline-block;margin-right:6px}
.btn{padding:6px 10px;border:1px solid #c6cfda;border-radius:8px;background:#fff;text-decoration:none}
.btn.del{border-color:#f3b5b5}
</style>
</head>
<body>
  <div class="bar">
    <h1>Fichas (<?= $total ?>)</h1>
    <a class="btn" href="<?= public_url('menu.php') ?>">Menu</a>
    <form method="get" style="margin-left:auto;display:flex;gap:6px">
      <input type="text" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="Buscar nome, e-mail, telefone">
      <button class="btn">Buscar</button>
    </form>
  </div>

  <table class="table">
    <thead><tr>
      <th>ID</th><th>Nome</th><th>E-mail</th><th>Telefone</th><th>Sexo</th><th>Idade</th><th>Criado em</th><th>Ações</th>
    </tr></thead>
    <tbody>
    <?php foreach($rows as $r): ?>
      <tr>
        <td><?= (int)$r['id'] ?></td>
        <td><?= htmlspecialchars($r['nome_completo']) ?></td>
        <td><?= htmlspecialchars($r['email']) ?></td>
        <td><?= htmlspecialchars($r['telefone']) ?></td>
        <td><?= htmlspecialchars($r['sexo']) ?></td>
        <td><?= htmlspecialchars($r['idade']) ?></td>
        <td><?= htmlspecialchars($r['criado_em']) ?></td>
        <td class="actions">
          <a class="btn" href="<?= src_url('ver.php?id='.(int)$r['id']) ?>">Ver</a>
          <a class="btn" href="<?= src_url('editar.php?id='.(int)$r['id']) ?>">Editar</a>
          <form action="<?= src_url('excluir.php') ?>" method="post" style="display:inline" onsubmit="return confirm('Excluir este registro?');">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
            <button class="btn del" type="submit">Excluir</button>
          </form>
        </td>
      </tr>
    <?php endforeach; ?>
    <?php if(!$rows): ?>
      <tr><td colspan="8">Nenhum registro.</td></tr>
    <?php endif; ?>
    </tbody>
  </table>

  <p>
    <?php for($i=1;$i<=$pages;$i++): ?>
      <?php if($i === $page): ?><strong>[<?= $i ?>]</strong><?php else: ?>
        <a class="btn" href="?page=<?= $i ?>&q=<?= urlencode($q) ?>"><?= $i ?></a>
      <?php endif; ?>
    <?php endfor; ?>
  </p>
</body>
</html>
