CREATE DATABASE IF NOT EXISTS formulario_db
  CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE formulario_db;

CREATE TABLE IF NOT EXISTS ficha_anamnese_tirzepatida (
  id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
  nome_completo VARCHAR(150) NOT NULL,
  data_nascimento DATE NOT NULL,
  idade TINYINT UNSIGNED,
  sexo ENUM('M','F') NOT NULL,
  telefone VARCHAR(30),
  email VARCHAR(150),
  profissao VARCHAR(100),
  diabetes_tipo2 TINYINT(1) DEFAULT 0,
  diabetes_tipo1 TINYINT(1) DEFAULT 0,
  hipertensao TINYINT(1) DEFAULT 0,
  problemas_renais TINYINT(1) DEFAULT 0,
  doencas_hepaticas TINYINT(1) DEFAULT 0,
  pancreatite_dor_abdominal TINYINT(1) DEFAULT 0,
  doencas_gastrointestinais TINYINT(1) DEFAULT 0,
  cancer_tireoide TINYINT(1) DEFAULT 0,
  neoplasia_endocrina_multipla TINYINT(1) DEFAULT 0,
  alergias_medicamentosas TINYINT(1) DEFAULT 0,
  quais_alergias VARCHAR(255),
  medicamentos_uso_continuo TEXT,
  suplementos_vitaminas TEXT,
  objetivo_emagrecimento TINYINT(1) DEFAULT 0,
  objetivo_controle_glicemico TINYINT(1) DEFAULT 0,
  objetivo_reducao_compulsao TINYINT(1) DEFAULT 0,
  objetivo_melhoria_metabolismo TINYINT(1) DEFAULT 0,
  objetivo_outros VARCHAR(255),
  peso DECIMAL(5,2),
  altura DECIMAL(4,2),
  imc DECIMAL(5,2),
  cintura DECIMAL(5,1),
  abdomen DECIMAL(5,1),
  quadril DECIMAL(5,1),
  coxa DECIMAL(5,1),
  alimentacao_equilibrada TINYINT(1) DEFAULT 0,
  atividade_fisica TINYINT(1) DEFAULT 0,
  tipo_atividade VARCHAR(100),
  frequencia_atividade VARCHAR(50),
  ingestao_agua_adequada TINYINT(1) DEFAULT 0,
  media_agua_ml INT,
  alcool TINYINT(1) DEFAULT 0,
  frequencia_alcool VARCHAR(100),
  tabagismo TINYINT(1) DEFAULT 0,
  quantidade_tabaco VARCHAR(50),
  sono_reparador TINYINT(1) DEFAULT 0,
  horas_sono TINYINT UNSIGNED,
  utilizou_tirzepatida TINYINT(1) DEFAULT 0,
  data_inicio DATE,
  dosagem VARCHAR(100),
  forma_aquisicao ENUM('Prescrito','Outro'),
  outro_aquisicao VARCHAR(100),
  ciente_efeitos_colaterais TINYINT(1) DEFAULT 0,
  recebeu_orientacoes TINYINT(1) DEFAULT 0,
  consentimento TINYINT(1) DEFAULT 0,
  ip VARBINARY(16),
  user_agent VARCHAR(255),
  criado_em DATETIME DEFAULT CURRENT_TIMESTAMP,
  KEY idx_criado_em (criado_em),
  KEY idx_email (email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
