<?php
declare(strict_types=1);
if (!function_exists('ends_with')) {
  function ends_with(string $haystack, string $needle): bool {
    if ($needle === '') return true;
    return substr($haystack, -strlen($needle)) === $needle;
  }
}
if (!function_exists('public_url')) {
  function public_url(string $path = ''): string {
    $base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])), '/');
    if (substr($base, -4) === '/src') { $pub = substr($base, 0, -4).'/public'; }
    elseif (substr($base, -7) !== '/public') { $pub = $base.'/public'; }
    else { $pub = $base; }
    return rtrim($pub, '/').'/'.ltrim($path, '/');
  }
}
if (!function_exists('src_url')) {
  function src_url(string $path = ''): string {
    $base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])), '/');
    if (substr($base, -7) === '/public') { $src = substr($base, 0, -7).'/src'; }
    elseif (substr($base, -4) !== '/src') { $src = $base.'/src'; }
    else { $src = $base; }
    return rtrim($src, '/').'/'.ltrim($path, '/');
  }
}
