<?php
declare(strict_types=1);
function limpar(string $v): string { return trim(filter_var($v, FILTER_UNSAFE_RAW, FILTER_FLAG_STRIP_LOW | FILTER_FLAG_STRIP_HIGH)); }
function validar_email(string $e): bool { return (bool)filter_var($e, FILTER_VALIDATE_EMAIL); }
function ipBin(): ?string { $ip = $_SERVER['REMOTE_ADDR'] ?? ''; if (!$ip) return null; $p = @inet_pton($ip); return $p===false?null:$p; }
function ua(): string { return substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 255); }
function redirect(string $u): void { header('Location: '.$u, true, 302); exit; }
function calc_imc(?float $peso, ?float $altura): ?float { if ($peso and $altura and $altura>0) return round($peso/($altura*$altura),2); return null; }
function calc_idade(?string $data): ?int { if (!$data) return null; $d = DateTime::createFromFormat('Y-m-d', $data); if (!$d) return null; return (int)$d->diff(new DateTime('today'))->y; }
