<?php
declare(strict_types=1);
session_start();
require_once __DIR__.'/paths.php';
function auth_login(array $u): void { $_SESSION['user']=['id'=>$u['id'],'nome'=>$u['nome'],'login'=>$u['login'],'role'=>$u['role']]; }
function auth_user(): ?array { return $_SESSION['user'] ?? null; }
function auth_logout(): void { $_SESSION=[]; session_destroy(); }
function require_login(): void { if (!auth_user()) { header('Location: '.public_url('login.php')); exit; } }
function is_admin(): bool { return (auth_user()['role'] ?? '') === 'admin'; }
if (empty($_SESSION['csrf'])) $_SESSION['csrf']=bin2hex(random_bytes(32));
function csrf_token(): string { return $_SESSION['csrf']; }
function csrf_ok(string $t): bool { return hash_equals($_SESSION['csrf'], $t); }
