<?php
declare(strict_types=1);
require __DIR__.'/conexao_db.php'; require __DIR__.'/auth.php'; require __DIR__.'/funcoes.php';
if (session_status() !== PHP_SESSION_ACTIVE) session_start();

if (($_POST['website'] ?? '') !== '') { header('Location: ../public/index.php'); exit; }
$csrf = (string)($_POST['csrf'] ?? '');
if (!csrf_ok($csrf)) { http_response_code(400); exit('Falha de verificação CSRF.'); }

$cb = fn(string $k): int => isset($_POST[$k]) && (string)$_POST[$k] === '1' ? 1 : (int)($_POST[$k] ?? 0);
$get = fn(string $k): ?string => (($v = limpar((string)($_POST[$k] ?? ''))) !== '') ? $v : null;

$nome_completo   = limpar((string)($_POST['nome_completo'] ?? ''));
$data_nascimento = limpar((string)($_POST['data_nascimento'] ?? ''));
$sexo            = limpar((string)($_POST['sexo'] ?? ''));
$telefone        = $get('telefone');
$email           = $get('email');
$profissao       = $get('profissao');

$erros = [];
if ($nome_completo==='') $erros[]='Informe o nome completo.';
if ($data_nascimento==='') $erros[]='Informe a data de nascimento.';
if ($sexo!=='M' && $sexo!=='F') $erros[]='Informe o sexo.';
if ($email && !validar_email($email)) $erros[]='E-mail inválido.';
if (!isset($_POST['consentimento'])) $erros[]='É necessário aceitar o termo de ciência.';

if ($erros) { http_response_code(422); echo '<h2>Erros:</h2><ul>'; foreach($erros as $e) echo '<li>'.htmlspecialchars($e).'</li>'; echo '</ul><a href="../public/index.php">Voltar</a>'; exit; }

$idade = calc_idade($data_nascimento);

$peso   = isset($_POST['peso'])   && $_POST['peso']   !== '' ? (float)$_POST['peso']   : null;
$altura = isset($_POST['altura']) && $_POST['altura'] !== '' ? (float)$_POST['altura'] : null;
$imc    = isset($_POST['imc'])    && $_POST['imc']    !== '' ? (float)$_POST['imc']    : calc_imc($peso, $altura);

$sql = 'INSERT INTO ficha_anamnese_tirzepatida (
  nome_completo, data_nascimento, idade, sexo, telefone, email, profissao,
  diabetes_tipo2, diabetes_tipo1, hipertensao, problemas_renais, doencas_hepaticas, pancreatite_dor_abdominal,
  doencas_gastrointestinais, cancer_tireoide, neoplasia_endocrina_multipla, alergias_medicamentosas, quais_alergias,
  medicamentos_uso_continuo, suplementos_vitaminas,
  objetivo_emagrecimento, objetivo_controle_glicemico, objetivo_reducao_compulsao, objetivo_melhoria_metabolismo, objetivo_outros,
  peso, altura, imc, cintura, abdomen, quadril, coxa,
  alimentacao_equilibrada, atividade_fisica, tipo_atividade, frequencia_atividade, ingestao_agua_adequada, media_agua_ml,
  alcool, frequencia_alcool, tabagismo, quantidade_tabaco, sono_reparador, horas_sono,
  utilizou_tirzepatida, data_inicio, dosagem, forma_aquisicao, outro_aquisicao, ciente_efeitos_colaterais, recebeu_orientacoes,
  consentimento, ip, user_agent
) VALUES (
  :nome_completo, :data_nascimento, :idade, :sexo, :telefone, :email, :profissao,
  :diabetes_tipo2, :diabetes_tipo1, :hipertensao, :problemas_renais, :doencas_hepaticas, :pancreatite_dor_abdominal,
  :doencas_gastrointestinais, :cancer_tireoide, :neoplasia_endocrina_multipla, :alergias_medicamentosas, :quais_alergias,
  :medicamentos_uso_continuo, :suplementos_vitaminas,
  :objetivo_emagrecimento, :objetivo_controle_glicemico, :objetivo_reducao_compulsao, :objetivo_melhoria_metabolismo, :objetivo_outros,
  :peso, :altura, :imc, :cintura, :abdomen, :quadril, :coxa,
  :alimentacao_equilibrada, :atividade_fisica, :tipo_atividade, :frequencia_atividade, :ingestao_agua_adequada, :media_agua_ml,
  :alcool, :frequencia_alcool, :tabagismo, :quantidade_tabaco, :sono_reparador, :horas_sono,
  :utilizou_tirzepatida, :data_inicio, :dosagem, :forma_aquisicao, :outro_aquisicao, :ciente_efeitos_colaterais, :recebeu_orientacoes,
  :consentimento, :ip, :ua
)';
$st = $pdo->prepare($sql);

$params = [
  ':nome_completo'=>$nome_completo, ':data_nascimento'=>$data_nascimento, ':idade'=>$idade, ':sexo'=>$sexo,
  ':telefone'=>$telefone, ':email'=>$email, ':profissao'=>$profissao,
  ':diabetes_tipo2'=>$cb('diabetes_tipo2'), ':diabetes_tipo1'=>$cb('diabetes_tipo1'), ':hipertensao'=>$cb('hipertensao'),
  ':problemas_renais'=>$cb('problemas_renais'), ':doencas_hepaticas'=>$cb('doencas_hepaticas'), ':pancreatite_dor_abdominal'=>$cb('pancreatite_dor_abdominal'),
  ':doencas_gastrointestinais'=>$cb('doencas_gastrointestinais'), ':cancer_tireoide'=>$cb('cancer_tireoide'), ':neoplasia_endocrina_multipla'=>$cb('neoplasia_endocrina_multipla'),
  ':alergias_medicamentosas'=>$cb('alergias_medicamentosas'), ':quais_alergias'=>$get('quais_alergias'),
  ':medicamentos_uso_continuo'=>$get('medicamentos_uso_continuo'), ':suplementos_vitaminas'=>$get('suplementos_vitaminas'),
  ':objetivo_emagrecimento'=>$cb('objetivo_emagrecimento'), ':objetivo_controle_glicemico'=>$cb('objetivo_controle_glicemico'),
  ':objetivo_reducao_compulsao'=>$cb('objetivo_reducao_compulsao'), ':objetivo_melhoria_metabolismo'=>$cb('objetivo_melhoria_metabolismo'),
  ':objetivo_outros'=>$get('objetivo_outros'),
  ':peso'=>$peso, ':altura'=>$altura, ':imc'=>$imc,
  ':cintura'=>isset($_POST['cintura'])&&$_POST['cintura']!==''?(float)$_POST['cintura']:null,
  ':abdomen'=>isset($_POST['abdomen'])&&$_POST['abdomen']!==''?(float)$_POST['abdomen']:null,
  ':quadril'=>isset($_POST['quadril'])&&$_POST['quadril']!==''?(float)$_POST['quadril']:null,
  ':coxa'=>isset($_POST['coxa'])&&$_POST['coxa']!==''?(float)$_POST['coxa']:null,
  ':alimentacao_equilibrada'=>$cb('alimentacao_equilibrada'), ':atividade_fisica'=>$cb('atividade_fisica'),
  ':tipo_atividade'=>$get('tipo_atividade'), ':frequencia_atividade'=>$get('frequencia_atividade'),
  ':ingestao_agua_adequada'=>$cb('ingestao_agua_adequada'), ':media_agua_ml'=>isset($_POST['media_agua_ml'])&&$_POST['media_agua_ml']!==''?(int)$_POST['media_agua_ml']:null,
  ':alcool'=>$cb('alcool'), ':frequencia_alcool'=>$get('frequencia_alcool'), ':tabagismo'=>$cb('tabagismo'),
  ':quantidade_tabaco'=>$get('quantidade_tabaco'), ':sono_reparador'=>$cb('sono_reparador'),
  ':horas_sono'=>isset($_POST['horas_sono'])&&$_POST['horas_sono']!==''?(int)$_POST['horas_sono']:null,
  ':utilizou_tirzepatida'=>$cb('utilizou_tirzepatida'), ':data_inicio'=>$get('data_inicio'), ':dosagem'=>$get('dosagem'),
  ':forma_aquisicao'=>$get('forma_aquisicao'), ':outro_aquisicao'=>$get('outro_aquisicao'),
  ':ciente_efeitos_colaterais'=>isset($_POST['ciente_efeitos_colaterais'])?(int)$_POST['ciente_efeitos_colaterais']:0,
  ':recebeu_orientacoes'=>isset($_POST['recebeu_orientacoes'])?(int)$_POST['recebeu_orientacoes']:0,
  ':consentimento'=>1, ':ip'=>ipBin(), ':ua'=>ua(),
];

try { $st->execute($params); }
catch(Throwable $e){ http_response_code(500); exit('Erro ao salvar: '.htmlspecialchars($e->getMessage())); }

redirect('../public/obrigado.php');
