<?php
declare(strict_types=1);
function ends_with(string $haystack, string $needle): bool {
  if ($needle === '') return true;
  return substr($haystack, -strlen($needle)) === $needle;
}
function public_url(string $path = ''): string {
  $base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])), '/');
  if (ends_with($base, '/src')) { $pub = substr($base, 0, -4).'/public'; }
  elseif (!ends_with($base, '/public')) { $pub = $base.'/public'; }
  else { $pub = $base; }
  return rtrim($pub, '/').'/'.ltrim($path, '/');
}
function src_url(string $path = ''): string {
  $base = rtrim(str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'])), '/');
  if (ends_with($base, '/public')) { $src = substr($base, 0, -7).'/src'; }
  elseif (!ends_with($base, '/src')) { $src = $base.'/src'; }
  else { $src = $base; }
  return rtrim($src, '/').'/'.ltrim($path, '/');
}
