<?php require __DIR__.'/../src/auth.php'; require_login(); ?>
<?php require __DIR__.'/../src/funcoes.php'; if (session_status() !== PHP_SESSION_ACTIVE) session_start(); $token = $_SESSION['csrf'] ?? bin2hex(random_bytes(32)); $_SESSION['csrf']=$token; ?>
<!doctype html>
<html lang="pt-br">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Ficha de Anamnese – Tirzepatida</title>
<link rel="stylesheet" href="./assets/style.css">
</head>
<body>
<main class="container">
  <h1>Ficha de Anamnese – Tirzepatida (Mounjaro)</h1>
  <form action="../src/salvar_resposta.php" method="post" novalidate>
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($token) ?>">
    <div class="hp"><label>Deixe em branco</label><input type="text" name="website"></div>

    <section>
      <h2>Dados Pessoais</h2>
      <div class="grid g3">
        <label>Nome completo*<input type="text" name="nome_completo" required maxlength="150" autocomplete="name"></label>
        <label>Data de nascimento*<input type="date" name="data_nascimento" required></label>
        <label>Sexo*<select name="sexo" required><option value="">Selecione</option><option value="M">M</option><option value="F">F</option></select></label>
      </div>
      <div class="grid g3">
        <label>Telefone/WhatsApp<input type="tel" name="telefone" maxlength="30" autocomplete="tel"></label>
        <label>E-mail<input type="email" name="email" maxlength="150" autocomplete="email"></label>
        <label>Profissão<input type="text" name="profissao" maxlength="100"></label>
      </div>
    </section>

    <section>
      <h2>Histórico Médico</h2>
      <div class="checks">
        <?php $hx = [
          'diabetes_tipo2'=>'Diabetes Tipo 2','diabetes_tipo1'=>'Diabetes Tipo 1','hipertensao'=>'Hipertensão',
          'problemas_renais'=>'Problemas renais','doencas_hepaticas'=>'Doenças hepáticas','pancreatite_dor_abdominal'=>'Pancreatite/dor abdominal recorrente',
          'doencas_gastrointestinais'=>'Doenças gastrointestinais (refluxo, gastroparesia)','cancer_tireoide'=>'Câncer de tireoide (CMT)',
          'neoplasia_endocrina_multipla'=>'NEM tipo 2','alergias_medicamentosas'=>'Alergias medicamentosas'
        ]; foreach($hx as $name=>$label): ?>
        <label class="ck"><input type="checkbox" name="<?= $name ?>" value="1"> <?= $label ?></label>
        <?php endforeach; ?>
      </div>
      <label>Quais alergias? <input type="text" name="quais_alergias" maxlength="255"></label>
    </section>

    <section>
      <h2>Uso de Medicamentos</h2>
      <label>Medicamentos de uso contínuo<textarea name="medicamentos_uso_continuo" rows="2"></textarea></label>
      <label>Suplementos ou vitaminas<textarea name="suplementos_vitaminas" rows="2"></textarea></label>
    </section>

    <section>
      <h2>Objetivo do Tratamento</h2>
      <div class="checks">
        <?php $obj = [
          'objetivo_emagrecimento'=>'Emagrecimento','objetivo_controle_glicemico'=>'Controle glicêmico',
          'objetivo_reducao_compulsao'=>'Redução da compulsão alimentar','objetivo_melhoria_metabolismo'=>'Melhora do metabolismo'];
          foreach($obj as $name=>$label): ?>
          <label class="ck"><input type="checkbox" name="<?= $name ?>" value="1"> <?= $label ?></label>
        <?php endforeach; ?>
      </div>
      <label>Outros <input type="text" name="objetivo_outros" maxlength="255"></label>
    </section>

    <section>
      <h2>Avaliação Corporal</h2>
      <div class="grid g3">
        <label>Peso (kg)<input type="number" step="0.01" name="peso"></label>
        <label>Altura (m)<input type="number" step="0.01" name="altura"></label>
        <label>IMC (auto)<input type="number" step="0.01" name="imc" placeholder="Calculado no envio"></label>
      </div>
      <div class="grid g4">
        <label>Cintura (cm)<input type="number" step="0.1" name="cintura"></label>
        <label>Abdômen (cm)<input type="number" step="0.1" name="abdomen"></label>
        <label>Quadril (cm)<input type="number" step="0.1" name="quadril"></label>
        <label>Coxa (cm)<input type="number" step="0.1" name="coxa"></label>
      </div>
    </section>

    <section>
      <h2>Hábitos de Vida</h2>
      <div class="checks">
        <label class="ck"><input type="checkbox" name="alimentacao_equilibrada" value="1"> Alimentação equilibrada</label>
        <label class="ck"><input type="checkbox" name="atividade_fisica" value="1"> Atividade física</label>
        <label>Tipo de atividade <input type="text" name="tipo_atividade" maxlength="100"></label>
        <label>Frequência <input type="text" name="frequencia_atividade" maxlength="50"></label>
        <label class="ck"><input type="checkbox" name="ingestao_agua_adequada" value="1"> Ingestão de água adequada</label>
        <label>Média (ml/dia) <input type="number" name="media_agua_ml"></label>
        <label class="ck"><input type="checkbox" name="alcool" value="1"> Álcool</label>
        <label>Frequência <input type="text" name="frequencia_alcool" maxlength="100"></label>
        <label class="ck"><input type="checkbox" name="tabagismo" value="1"> Tabagismo</label>
        <label>Quantidade <input type="text" name="quantidade_tabaco" maxlength="50"></label>
        <label class="ck"><input type="checkbox" name="sono_reparador" value="1"> Sono reparador</label>
        <label>Horas por noite <input type="number" name="horas_sono" min="0" max="24"></label>
      </div>
    </section>

    <section>
      <h2>Tirzepatida (Mounjaro)</h2>
      <div class="grid g3">
        <label>Já utilizou?<select name="utilizou_tirzepatida"><option value="0">Não</option><option value="1">Sim</option></select></label>
        <label>Data de início<input type="date" name="data_inicio"></label>
        <label>Dosagem<input type="text" name="dosagem" maxlength="100"></label>
      </div>
      <div class="grid g3">
        <label>Forma de aquisição<select name="forma_aquisicao"><option value="">Selecione</option><option value="Prescrito">Prescrito</option><option value="Outro">Outro</option></select></label>
        <label>Se "Outro", qual?<input type="text" name="outro_aquisicao" maxlength="100"></label>
        <label>Ciente de possíveis efeitos?<select name="ciente_efeitos_colaterais"><option value="0">Não</option><option value="1">Sim</option></select></label>
      </div>
      <label>Recebeu orientações adequadas?
        <select name="recebeu_orientacoes"><option value="0">Não</option><option value="1">Sim</option></select>
      </label>
    </section>

    <label class="consent"><input type="checkbox" name="consentimento" value="1" required> Declaro ciência e responsabilidade sobre as informações prestadas.</label>

    <button type="submit">Salvar</button>
  </form>
</main>
</body>
</html>
